"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VizChartWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _split_chart_warning_helpers = require("../utils/split_chart_warning_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SwitchToOldLibraryMessage = ({
  canEditAdvancedSettings,
  advancedSettingsLink,
  mode = 'old'
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canEditAdvancedSettings && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newChart.conditionalMessage.newLibrary",
    defaultMessage: "Switch to the {type} library in {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: advancedSettingsLink
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visualizations.newChart.conditionalMessage.advancedSettingsLink",
        defaultMessage: "Advanced Settings."
      })),
      type: mode === 'old' ? _i18n.i18n.translate('visualizations.newChart.libraryMode.old', {
        defaultMessage: 'old'
      }) : _i18n.i18n.translate('visualizations.newChart.libraryMode.new', {
        defaultMessage: 'new'
      })
    }
  }));
};
const ContactAdminMessage = ({
  canEditAdvancedSettings
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !canEditAdvancedSettings && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.legacyCharts.conditionalMessage.noPermissions",
    defaultMessage: "Contact your system administrator to switch to the old library."
  }));
};
const GaugeWarningFormatMessage = props => {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newGaugeChart.notificationMessage",
    defaultMessage: "The new gauge charts library does not yet support split chart aggregation. {conditionalMessage}",
    values: {
      conditionalMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SwitchToOldLibraryMessage, props), /*#__PURE__*/_react.default.createElement(ContactAdminMessage, props))
    }
  });
};
const PieWarningFormatMessage = props => {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.oldPieChart.notificationMessage",
    defaultMessage: "You are using the legacy charts library, which will be removed in a future version. {conditionalMessage}",
    values: {
      conditionalMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SwitchToOldLibraryMessage, props), /*#__PURE__*/_react.default.createElement(ContactAdminMessage, props))
    }
  });
};
const ControlsWarningFormatMessage = props => {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.controls.notificationMessage",
    defaultMessage: "Input controls are deprecated and will be removed in a future release. Use the new Controls to filter and interact with your dashboard data. "
  });
};
const warningMessages = {
  [_split_chart_warning_helpers.CHARTS_WITHOUT_SMALL_MULTIPLES.gauge]: GaugeWarningFormatMessage,
  [_split_chart_warning_helpers.CHARTS_TO_BE_DEPRECATED.pie]: PieWarningFormatMessage,
  [_split_chart_warning_helpers.CHARTS_TO_BE_DEPRECATED.controls]: ControlsWarningFormatMessage
};
const VizChartWarning = ({
  chartType,
  chartConfigToken,
  mode
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const canEditAdvancedSettings = services.application.capabilities.advancedSettings.save;
  const advancedSettingsLink = services.application.getUrlForApp('management', {
    path: `/kibana/settings?query=${chartConfigToken}`
  });
  const WarningMessage = warningMessages[chartType];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "vizChartWarning",
    title: /*#__PURE__*/_react.default.createElement(WarningMessage, {
      advancedSettingsLink: advancedSettingsLink,
      canEditAdvancedSettings: canEditAdvancedSettings,
      mode: mode
    }),
    iconType: "warning",
    color: "warning",
    size: "s"
  });
};
exports.VizChartWarning = VizChartWarning;