"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeEditApi = initializeEditApi;
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _ = require("..");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeEditApi({
  customTimeRange$,
  description$,
  parentApi,
  savedObjectId$,
  searchSessionId$,
  title$,
  vis$,
  uuid
}) {
  return !parentApi || !(0, _presentationPublishing.apiHasAppContext)(parentApi) ? {} : {
    getTypeDisplayName: () => _i18n.i18n.translate('visualizations.displayName', {
      defaultMessage: 'visualization'
    }),
    onEdit: async () => {
      var _parentApiContext$get;
      const stateTransferService = (0, _services.getEmbeddable)().getStateTransfer();
      const visId = savedObjectId$.getValue();
      const editPath = visId ? (0, _.urlFor)(visId) : '#/edit_by_value';
      const parentTimeRange = (0, _presentationPublishing.apiPublishesTimeRange)(parentApi) ? parentApi.timeRange$.getValue() : {};
      const customTimeRange = customTimeRange$.getValue();
      const parentApiContext = parentApi.getAppContext();
      await stateTransferService.navigateToEditor('visualize', {
        path: editPath,
        state: {
          embeddableId: uuid,
          valueInput: {
            savedVis: vis$.getValue().serialize(),
            title: title$.getValue(),
            description: description$.getValue(),
            timeRange: customTimeRange !== null && customTimeRange !== void 0 ? customTimeRange : parentTimeRange
          },
          originatingApp: parentApiContext === null || parentApiContext === void 0 ? void 0 : parentApiContext.currentAppId,
          searchSessionId: searchSessionId$.getValue() || undefined,
          originatingPath: parentApiContext === null || parentApiContext === void 0 ? void 0 : (_parentApiContext$get = parentApiContext.getCurrentPath) === null || _parentApiContext$get === void 0 ? void 0 : _parentApiContext$get.call(parentApiContext)
        }
      });
    },
    isEditingEnabled: () => {
      var _capabilities$dashboa, _capabilities$visuali, _capabilities$visuali2;
      const readOnly = Boolean(vis$.getValue().type.disableEdit);
      if (readOnly) return false;
      const capabilities = (0, _services.getCapabilities)();
      const isByValue = !savedObjectId$.getValue();
      if (isByValue) return Boolean(((_capabilities$dashboa = capabilities.dashboard) === null || _capabilities$dashboa === void 0 ? void 0 : _capabilities$dashboa.showWriteControls) && ((_capabilities$visuali = capabilities.visualize) === null || _capabilities$visuali === void 0 ? void 0 : _capabilities$visuali.show));else return Boolean((_capabilities$visuali2 = capabilities.visualize) === null || _capabilities$visuali2 === void 0 ? void 0 : _capabilities$visuali2.save);
    }
  };
}