"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizationsClient = void 0;
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const get = async id => {
  return (0, _services.getContentManagement)().client.get({
    contentTypeId: 'visualization',
    id
  });
};
const create = async ({
  data,
  options
}) => {
  const res = await (0, _services.getContentManagement)().client.create({
    contentTypeId: 'visualization',
    data,
    options
  });
  return res;
};
const update = async ({
  id,
  data,
  options
}) => {
  const res = await (0, _services.getContentManagement)().client.update({
    contentTypeId: 'visualization',
    id,
    data,
    options
  });
  return res;
};
const deleteVisualization = async id => {
  const res = await (0, _services.getContentManagement)().client.delete({
    contentTypeId: 'visualization',
    id
  });
  return res;
};
const search = async (query = {}, options) => {
  if (options && options.types && options.types.length > 1) {
    const {
      types
    } = options;
    return (0, _services.getContentManagement)().client.mSearch({
      contentTypes: types.map(type => ({
        contentTypeId: type
      })),
      query
    });
  }
  return (0, _services.getContentManagement)().client.search({
    contentTypeId: 'visualization',
    query,
    options
  });
};
const visualizationsClient = exports.visualizationsClient = {
  get,
  create,
  update,
  delete: deleteVisualization,
  search
};