"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.VisualizationNoResults = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class VisualizationNoResults extends _react.default.Component {
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "visNoResult",
      className: "visError"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "visualizeApp",
      iconColor: "default",
      "data-test-subj": "visualization-error",
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        className: "visualization-error-text"
      }, _i18n.i18n.translate('visualizations.noResultsFoundTitle', {
        defaultMessage: 'No results found'
      }))
    }));
  }
  componentDidMount() {
    this.afterRender();
  }
  componentDidUpdate() {
    this.afterRender();
  }
  afterRender() {
    if (this.props.onInit) {
      this.props.onInit();
    }
  }
}

// eslint-disable-next-line import/no-default-export
exports.VisualizationNoResults = VisualizationNoResults;
var _default = exports.default = VisualizationNoResults;