"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.countNextAxisNumber = countNextAxisNumber;
exports.isAxisHorizontal = exports.getUpdatedAxisName = void 0;
exports.mapPosition = mapPosition;
exports.mapPositionOpposingOpposite = mapPositionOpposingOpposite;
exports.mapPositionOpposite = mapPositionOpposite;
var _lodash = require("lodash");
var _charts = require("@elastic/charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isAxisHorizontal = position => [_charts.Position.Top, _charts.Position.Bottom].includes(position);
exports.isAxisHorizontal = isAxisHorizontal;
const RADIX = 10;
function countNextAxisNumber(axisName, axisProp = 'id') {
  return (value, axis) => {
    const nameLength = axisName.length;
    if (axis[axisProp].substr(0, nameLength) === axisName) {
      const num = parseInt(axis[axisProp].substr(nameLength), RADIX);
      if (num >= value) {
        value = num + 1;
      }
    }
    return value;
  };
}
const AXIS_PREFIX = 'Axis-';
const getUpdatedAxisName = (axisPosition, valueAxes) => {
  const axisName = (0, _lodash.upperFirst)(axisPosition) + AXIS_PREFIX;
  const nextAxisNameNumber = valueAxes.reduce(countNextAxisNumber(axisName, 'name'), 1);
  return `${axisName}${nextAxisNameNumber}`;
};

/**
 * Maps axis position to opposite position
 * @param position
 */
exports.getUpdatedAxisName = getUpdatedAxisName;
function mapPositionOpposite(position) {
  switch (position) {
    case _charts.Position.Bottom:
      return _charts.Position.Top;
    case _charts.Position.Top:
      return _charts.Position.Bottom;
    case _charts.Position.Left:
      return _charts.Position.Right;
    case _charts.Position.Right:
      return _charts.Position.Left;
    default:
      throw new Error('Invalid legend position.');
  }
}

/**
 * Maps axis position to new position or opposite of new position based on old position
 * @param position
 * @param oldPosition
 * @param newPosition
 */
function mapPositionOpposingOpposite(position, oldPosition, newPosition) {
  if (position === oldPosition) {
    return newPosition;
  }
  return mapPositionOpposite(newPosition);
}

/**
 * Maps axis position to opposite rotation position
 * @param position
 */
function mapPosition(position) {
  switch (position) {
    case _charts.Position.Bottom:
      return _charts.Position.Left;
    case _charts.Position.Top:
      return _charts.Position.Right;
    case _charts.Position.Left:
      return _charts.Position.Bottom;
    case _charts.Position.Right:
      return _charts.Position.Top;
  }
}