"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.optionTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _options = require("./components/options");
var _validation_wrapper = require("./components/common/validation_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const optionTabs = exports.optionTabs = [{
  name: 'advanced',
  title: _i18n.i18n.translate('visTypeXy.area.tabs.metricsAxesTitle', {
    defaultMessage: 'Metrics & axes'
  }),
  editor: props => /*#__PURE__*/_react.default.createElement(_validation_wrapper.ValidationWrapper, (0, _extends2.default)({}, props, {
    component: _options.MetricsAxisOptions
  }))
}, {
  name: 'options',
  title: _i18n.i18n.translate('visTypeXy.area.tabs.panelSettingsTitle', {
    defaultMessage: 'Panel settings'
  }),
  editor: props => /*#__PURE__*/_react.default.createElement(_validation_wrapper.ValidationWrapper, (0, _extends2.default)({}, props, {
    component: _options.PointSeriesOptions
  }))
}];