"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToLens = void 0;
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _services = require("../services");
var _get_series_params = require("../utils/get_series_params");
var _configurations = require("./configurations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SIBBLING_PIPELINE_AGGS = [_public.METRIC_TYPES.AVG_BUCKET, _public.METRIC_TYPES.SUM_BUCKET, _public.METRIC_TYPES.MAX_BUCKET, _public.METRIC_TYPES.MIN_BUCKET];
const convertToLens = async (vis, timefilter) => {
  var _vis$data$indexPatter, _visSchemas$group;
  if (!timefilter) {
    return null;
  }
  const dataViews = (0, _services.getDataViewsStart)();
  const dataView = await (0, _public2.getDataViewByIndexPatternId)((_vis$data$indexPatter = vis.data.indexPattern) === null || _vis$data$indexPatter === void 0 ? void 0 : _vis$data$indexPatter.id, dataViews);
  if (!dataView) {
    return null;
  }
  const visSchemas = (0, _public2.getVisSchemas)(vis, {
    timefilter,
    timeRange: timefilter.getAbsoluteTime()
  });

  // doesn't support multi split series
  if (visSchemas.group && visSchemas.group.length > 1) {
    return null;
  }
  const firstValueAxesId = vis.params.valueAxes[0].id;
  const updatedSeries = (0, _get_series_params.getSeriesParams)(vis.data.aggs, vis.params.seriesParams, 'metric', firstValueAxesId);
  const finalSeriesParams = updatedSeries !== null && updatedSeries !== void 0 ? updatedSeries : vis.params.seriesParams;
  const visibleSeries = finalSeriesParams.filter(param => param.show && visSchemas.metric.some(m => {
    var _m$aggId;
    return ((_m$aggId = m.aggId) === null || _m$aggId === void 0 ? void 0 : _m$aggId.split('.')[0]) === param.data.id;
  }));
  const {
    getColumnsFromVis,
    createStaticValueColumn
  } = await (0, _public2.getConvertToLensModule)();
  const dataLayers = getColumnsFromVis(vis, timefilter, dataView, {
    buckets: ['segment'],
    splits: ['group'],
    unsupported: ['split_row', 'split_column', 'radius']
  }, {
    dropEmptyRowsInDateHistogram: true,
    supportMixedSiblingPipelineAggs: true,
    isPercentageMode: false
  }, visibleSeries.reduce((acc, s) => {
    const series = acc.find(({
      type,
      mode
    }) => type === s.type && mode === s.mode);
    // sibling pipeline agg always generate new layer because of custom bucket
    if (series && visSchemas.metric.some(m => {
      var _m$aggId2;
      return ((_m$aggId2 = m.aggId) === null || _m$aggId2 === void 0 ? void 0 : _m$aggId2.split('.')[0]) === s.data.id && !SIBBLING_PIPELINE_AGGS.includes(m.aggType);
    })) {
      series.metrics.push(s.data.id);
    } else {
      acc.push({
        metrics: [s.data.id],
        type: s.type,
        mode: s.mode
      });
    }
    return acc;
  }, []).map(({
    metrics
  }) => ({
    metrics
  })));
  if (dataLayers === null) {
    return null;
  }

  // doesn't support several layers with terms split series which uses one of the metrics as order agg
  if (dataLayers.length > 1 && dataLayers.some(l => l.columns.some(c => c.isSplit && 'orderBy' in c.params && c.params.orderBy.type === 'column'))) {
    return null;
  }

  // doesn't support sibling pipeline aggs and split series together
  if ((_visSchemas$group = visSchemas.group) !== null && _visSchemas$group !== void 0 && _visSchemas$group.length && dataLayers.some(l => Object.keys(l.buckets.customBuckets).length)) {
    return null;
  }
  const visibleYAxes = vis.params.valueAxes.filter(axis => visibleSeries.some(seriesParam => seriesParam.valueAxis === axis.id));
  const positions = visibleYAxes.map(axis => axis.position);
  const uniqPoisitions = new Set(positions);

  // doesn't support more than one axis left/right/top/bottom
  if (visibleYAxes.length > 1 && uniqPoisitions.size !== positions.length) {
    return null;
  }
  const indexPatternId = dataView.id;
  const {
    v4: uuidv4
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('uuid')));
  const layers = dataLayers.map(l => {
    const layerId = uuidv4();
    const seriesIdsMap = {};
    visibleSeries.forEach(s => {
      const column = l.columns.find(c => !c.isBucketed && c.meta.aggId.split('.')[0] === s.data.id);
      if (column) {
        seriesIdsMap[column.columnId] = s.data.id;
      }
    });
    const collapseFn = l.bucketCollapseFn ? Object.keys(l.bucketCollapseFn).find(key => l.bucketCollapseFn[key].includes(l.buckets.customBuckets[l.metrics[0]])) : undefined;
    return {
      indexPatternId,
      layerId,
      columns: l.columns.map(_convert_to_lens.excludeMetaFromColumn),
      metrics: l.metrics,
      columnOrder: [],
      seriesIdsMap,
      collapseFn,
      isReferenceLineLayer: false,
      ignoreGlobalFilters: false
    };
  });
  if (vis.params.thresholdLine.show) {
    const staticValueColumn = createStaticValueColumn(vis.params.thresholdLine.value || 0);
    layers.push({
      indexPatternId,
      layerId: uuidv4(),
      columns: [staticValueColumn],
      columnOrder: [],
      metrics: [staticValueColumn.columnId],
      isReferenceLineLayer: true,
      ignoreGlobalFilters: false,
      collapseFn: undefined,
      seriesIdsMap: {}
    });
  }
  return {
    type: 'lnsXY',
    layers: layers.map(({
      seriesIdsMap,
      collapseFn,
      isReferenceLineLayer,
      ...rest
    }) => rest),
    configuration: (0, _configurations.getConfiguration)(layers, visibleSeries, vis),
    indexPatternIds: [indexPatternId]
  };
};
exports.convertToLens = convertToLens;