"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chartTitleSplit = chartTitleSplit;
var _d = _interopRequireDefault(require("d3"));
var _jquery = _interopRequireDefault(require("jquery"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * Adds div DOM elements to either the `.visAxis__splitTitles--y` element or the
 * `.visAxis__splitTitles--x` element based on the data layout.
 * For example, if the data has rows, it returns the same number of
 * `.chart-title` elements as row objects.
 * if not data.rows or data.columns, return no chart titles
 */
function chartTitleSplit(selection) {
  selection.each(function (data) {
    const div = _d.default.select(this);
    const parent = (0, _jquery.default)(this).parents('.visWrapper');
    if (!data.series) {
      div.selectAll('.chart-title').data(function (d) {
        return d.rows ? d.rows : d.columns;
      }).enter().append('div').attr('class', 'chart-title');
      if (data.rows) {
        parent.find('.visAxis__splitTitles--x').remove();
      } else {
        parent.find('.visAxis__splitTitles--y').remove();
      }
      return div;
    }
    return _d.default.select(this).remove();
  });
}