"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorHandler = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Common errors shared between constructors
 *
 * @class ErrorHandler
 * @constructor
 */
class ErrorHandler {
  constructor() {}

  /**
   * Validates the height and width are > 0
   * min size must be at least 1 px
   *
   * @method validateWidthandHeight
   * @param width {Number} HTMLElement width
   * @param height {Number} HTMLElement height
   * @returns {HTMLElement} HTML div with an error message
   */
  validateWidthandHeight(width, height) {
    const badWidth = _lodash.default.isNaN(width) || width <= 0;
    const badHeight = _lodash.default.isNaN(height) || height <= 0;
    if (badWidth || badHeight) {
      throw new _errors.ContainerTooSmall();
    }
  }
}
exports.ErrorHandler = ErrorHandler;