"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectZeros = injectZeros;
var _ordered_x_keys = require("./ordered_x_keys");
var _zero_filled_array = require("./zero_filled_array");
var _zero_fill_data_array = require("./zero_fill_data_array");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * A Kibana data object may have multiple series with different array lengths.
 * This proves an impediment to stacking in the visualization library.
 * Therefore, zero values must be injected wherever these arrays do not line up.
 * That is, each array must have the same x values with zeros filled in where the
 * x values were added.
 *
 * This function and its helper functions accepts a Kibana data object
 * and injects zeros where needed.
 */

function injectZeros(obj, data, orderBucketsBySum = false) {
  const keys = (0, _ordered_x_keys.orderXValues)(data, orderBucketsBySum);
  obj.forEach(function (series) {
    const zeroArray = (0, _zero_filled_array.createZeroFilledArray)(keys, series.label);
    series.values = (0, _zero_fill_data_array.zeroFillDataArray)(zeroArray, series.values);
  });
  return obj;
}