"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VegaView = void 0;
var _vega = require("vega");
var _vega_base_view = require("./vega_base_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class VegaView extends _vega_base_view.VegaBaseView {
  async _initViewCustomizations() {
    // In some cases, Vega may be initialized twice... TBD
    if (!this._container) return;
    const view = new _vega.View((0, _vega.parse)(this._parser.spec, undefined, {
      ast: true
    }), this._vegaViewConfig);
    if (this._parser.useResize) this.updateVegaSize(view);
    view.initialize(this._container, this._controls);
    // resize again to take controls into account
    if (this._parser.useResize) this.updateVegaSize(view);
    if (this._parser.useHover) view.hover();
    await this.setView(view);
    this.setDebugValues(view, this._parser.spec, this._parser.vlspec);
  }
}
exports.VegaView = VegaView;