"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldShowMapLayerInfo = exports.ExperimentalMapLayerInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ExperimentalMapLayerInfo = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  className: "hide-for-sharing",
  "data-test-subj": "experimentalMapLayerInfo",
  size: "s",
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeVega.mapView.experimentalMapLayerInfo",
    defaultMessage: "This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are are not subject to the support SLA of official GA features. For feedback, please create an issue in {githubLink}.",
    values: {
      githubLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: "https://github.com/elastic/kibana/issues/new/choose",
        target: "_blank"
      }, "GitHub")
    }
  }),
  iconType: "beaker"
});
exports.ExperimentalMapLayerInfo = ExperimentalMapLayerInfo;
const shouldShowMapLayerInfo = spec => {
  var _spec$config, _spec$config$kibana;
  return ((_spec$config = spec.config) === null || _spec$config === void 0 ? void 0 : (_spec$config$kibana = _spec$config.kibana) === null || _spec$config$kibana === void 0 ? void 0 : _spec$config$kibana.type) === 'map';
};
exports.shouldShowMapLayerInfo = shouldShowMapLayerInfo;