"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilterRatioFormula = void 0;
var _supported_metrics = require("./supported_metrics");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const escapeQuotes = str => {
  return str === null || str === void 0 ? void 0 : str.replace(/\\/g, '\\\\').replace(/'/g, "\\'");
};
const constructFilterRationFormula = (operation, metric, additionalArgs) => {
  var _metric$query;
  return `${operation}${(metric === null || metric === void 0 ? void 0 : metric.language) === 'lucene' ? 'lucene' : 'kql'}='${metric !== null && metric !== void 0 && metric.query && typeof (metric === null || metric === void 0 ? void 0 : metric.query) === 'string' ? escapeQuotes(metric === null || metric === void 0 ? void 0 : metric.query) : (_metric$query = metric === null || metric === void 0 ? void 0 : metric.query) !== null && _metric$query !== void 0 ? _metric$query : '*'}'${additionalArgs ? (0, _.addAdditionalArgs)(additionalArgs) : ''})`;
};
const getFilterRatioFormula = (currentMetric, additionalArgs) => {
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const {
    numerator,
    denominator,
    metric_agg,
    field
  } = currentMetric;
  let aggregation = _supported_metrics.SUPPORTED_METRICS.count;
  if (metric_agg) {
    aggregation = _supported_metrics.SUPPORTED_METRICS[metric_agg];
    if (!aggregation) {
      return null;
    }
  }
  const aggFormula = (0, _supported_metrics.getFormulaFromMetric)(aggregation);
  const operation = metric_agg && metric_agg !== 'count' ? `${aggFormula}('${field}',` : 'count(';
  if (aggregation.name === 'counter_rate') {
    const numeratorFormula = `counter_rate(${constructFilterRationFormula(`(max('${field}',`, numerator, additionalArgs)})`;
    const denominatorFormula = `counter_rate(${constructFilterRationFormula(`(max('${field}',`, denominator, additionalArgs)})`;
    return `${numeratorFormula}) / ${denominatorFormula})`;
  } else {
    const numeratorFormula = constructFilterRationFormula(operation, numerator, additionalArgs);
    const denominatorFormula = constructFilterRationFormula(operation, denominator, additionalArgs);
    return `${numeratorFormula} / ${denominatorFormula}`;
  }
};
exports.getFilterRatioFormula = getFilterRatioFormula;