"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractOrGenerateDatasourceInfo = void 0;
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getOverwrittenIndexPattern = async (overwrittenIndexPattern, overwrittenTimeField, dataViews) => {
  if ((0, _index_patterns_utils.isStringTypeIndexPattern)(overwrittenIndexPattern)) {
    var _indexPattern$id;
    const indexPattern = await dataViews.create({
      id: `tsvb_ad_hoc_${overwrittenIndexPattern}${overwrittenTimeField ? '/' + overwrittenTimeField : ''}`,
      title: overwrittenIndexPattern,
      timeFieldName: overwrittenTimeField
    }, false, false);
    const indexPatternId = (_indexPattern$id = indexPattern.id) !== null && _indexPattern$id !== void 0 ? _indexPattern$id : '';
    const timeField = indexPattern.timeFieldName;
    return {
      indexPattern,
      indexPatternId,
      timeField
    };
  } else if (overwrittenIndexPattern) {
    const indexPattern = await dataViews.get(overwrittenIndexPattern.id);
    if (indexPattern) {
      var _indexPattern$id2;
      const indexPatternId = (_indexPattern$id2 = indexPattern.id) !== null && _indexPattern$id2 !== void 0 ? _indexPattern$id2 : '';
      const timeField = overwrittenTimeField !== null && overwrittenTimeField !== void 0 ? overwrittenTimeField : indexPattern.timeFieldName;
      return {
        indexPattern,
        indexPatternId,
        timeField
      };
    }
  }
  return null;
};
const getSelectedIndexPattern = async (selectedIndexPattern, selectedTimeField, dataViews) => {
  var _indexPattern$id4;
  if ((0, _index_patterns_utils.isStringTypeIndexPattern)(selectedIndexPattern)) {
    var _indexPattern$id3;
    if (!selectedTimeField) {
      throw new Error('Time field is empty');
    }
    const indexPattern = await dataViews.create({
      id: `tsvb_ad_hoc_${selectedIndexPattern}${selectedTimeField ? '/' + selectedTimeField : ''}`,
      title: selectedIndexPattern,
      timeFieldName: selectedTimeField
    }, false, false);
    const indexPatternId = (_indexPattern$id3 = indexPattern.id) !== null && _indexPattern$id3 !== void 0 ? _indexPattern$id3 : '';
    return {
      indexPattern,
      indexPatternId,
      timeField: indexPattern.timeFieldName
    };
  }
  const indexPattern = await dataViews.getDefault();
  const indexPatternId = (_indexPattern$id4 = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.id) !== null && _indexPattern$id4 !== void 0 ? _indexPattern$id4 : '';
  const timeField = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.timeFieldName;
  return {
    indexPattern,
    indexPatternId,
    timeField
  };
};
const extractOrGenerateDatasourceInfo = async (currentIndexPattern, currentTimeField, isOverwritten, overwrittenIndexPattern, overwrittenTimeField, dataViews) => {
  try {
    let indexPatternId = currentIndexPattern && !(0, _index_patterns_utils.isStringTypeIndexPattern)(currentIndexPattern) ? currentIndexPattern.id : '';
    let timeField = currentTimeField;
    let indexPattern;
    // handle override index pattern
    if (isOverwritten) {
      const result = await getOverwrittenIndexPattern(overwrittenIndexPattern, overwrittenTimeField, dataViews);
      if (result) {
        [indexPattern, indexPatternId, timeField] = [result.indexPattern, result.indexPatternId, result.timeField];
      }
    }
    if (!indexPatternId) {
      const result = await getSelectedIndexPattern(currentIndexPattern, currentTimeField, dataViews);
      [indexPattern, indexPatternId, timeField] = [result.indexPattern, result.indexPatternId, result.timeField];
    } else {
      indexPattern = await dataViews.get(indexPatternId);
      if (!timeField) {
        timeField = indexPattern.timeFieldName;
      }
    }
    return {
      indexPatternId,
      timeField,
      indexPattern
    };
  } catch (e) {
    return null;
  }
};
exports.extractOrGenerateDatasourceInfo = extractOrGenerateDatasourceInfo;