"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToFiltersParams = exports.convertToFiltersColumn = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const convertToFiltersParams = series => {
  const splitFilters = [];
  if (series.split_mode === 'filter' && series.filter) {
    splitFilters.push({
      filter: series.filter
    });
  }
  if (series.split_filters) {
    splitFilters.push(...series.split_filters);
  }
  return {
    filters: splitFilters === null || splitFilters === void 0 ? void 0 : splitFilters.map(param => {
      var _param$label;
      const query = param.filter ? param.filter.query : '';
      const language = param.filter ? param.filter.language : 'kuery';
      return {
        input: {
          query,
          language
        },
        label: (_param$label = param.label) !== null && _param$label !== void 0 ? _param$label : ''
      };
    })
  };
};
exports.convertToFiltersParams = convertToFiltersParams;
const convertToFiltersColumn = (series, isSplit) => {
  const params = convertToFiltersParams(series);
  if (!params.filters.length) {
    return null;
  }
  return {
    columnId: (0, _uuid.v4)(),
    operationType: 'filters',
    dataType: 'string',
    isBucketed: true,
    isSplit,
    params
  };
};
exports.convertToFiltersColumn = convertToFiltersColumn;