"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopN = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _last_value_utils = require("../../../../common/last_value_utils");
var _empty_label = require("../../../../common/empty_label");
var _render_counter = require("../../components/render_counter");
var _variables = require("./_variables");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const topNContainerStyle = ({
  euiTheme
}) => (0, _react2.css)`
  position: relative;
  overflow: auto;
  display: flex;
  flex-direction: column;

  tr:hover td {
    background-color: ${(0, _variables.getVisVariables)({
  euiTheme
}).tvbHoverBackgroundColor};
  }
`;
const topNValueStyle = ({
  euiTheme
}) => (0, _react2.css)`
  text-align: right;
  white-space: nowrap;
  line-height: 0;
  vertical-align: middle;
  color: ${(0, _variables.getVisVariables)({
  euiTheme
}).tvbValueColor};
  padding: ${euiTheme.size.xs};
  padding-bottom: 0;
`;
const topNLabelStyle = ({
  euiTheme
}) => (0, _react2.css)`
  color: ${(0, _variables.getVisVariables)({
  euiTheme
}).tvbTextColor};
  padding: ${euiTheme.size.xs} 0;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const topNBarStyle = ({
  euiTheme
}) => (0, _react2.css)`
  padding: ${euiTheme.size.xs} ${euiTheme.size.m};
  vertical-align: middle;
`;
const topNInnerBarStyle = ({
  euiTheme
}) => (0, _react2.css)`
  position: relative;

  > div {
    width: 100%;
    min-height: ${euiTheme.size.base};
  }
`;
const topNReversedStyles = ({
  euiTheme
}) => {
  const {
    tvbHoverBackgroundColorReversed,
    tvbTextColorReversed,
    tvbValueColorReversed
  } = (0, _variables.getVisVariables)({
    euiTheme
  });
  return (0, _react2.css)`
    tr:hover td {
      background-color: ${tvbHoverBackgroundColorReversed};
    }

    .tvbVisTopN__label {
      color: ${tvbTextColorReversed};
    }

    .tvbVisTopN__value {
      color: ${tvbValueColorReversed};
    }
  `;
};
const RENDER_MODES = {
  POSITIVE: 'positive',
  NEGATIVE: 'negative',
  MIXED: 'mixed'
};
class TopN extends _react.Component {
  constructor(props) {
    super(props);
    this.tableRef = /*#__PURE__*/_react.default.createRef();
    this.state = {
      labelMaxWidth: 150
    };
  }
  get labelMaxWidth() {
    // calculate max-width of a label column as 35% of the table
    return this.tableRef.current.offsetWidth * 0.35;
  }
  componentDidMount() {
    this.setState({
      labelMaxWidth: this.labelMaxWidth
    });
  }
  componentDidUpdate(prevProps, prevState) {
    if (prevState.labelMaxWidth !== this.labelMaxWidth) {
      this.setState({
        labelMaxWidth: this.labelMaxWidth
      });
    }
  }
  handleClick(item) {
    return () => {
      if (this.props.onClick) {
        this.props.onClick(item);
      }
    };
  }
  renderRow({
    min,
    max
  }) {
    return item => {
      const renderMode = TopN.getRenderMode(min, max);
      const key = `${item.id || item.label}`;
      const lastValue = (0, _last_value_utils.getLastValue)(item.data);
      const lastValueFormatted = (0, _last_value_utils.isEmptyValue)(lastValue) ? 0 : lastValue;
      const formatter = item.tickFormatter || this.props.tickFormatter;
      const isPositiveValue = lastValueFormatted >= 0;
      const intervalLength = TopN.calcDomain(renderMode, min, max);
      // if both are 0, the division returns NaN causing unexpected behavior.
      // For this it defaults to 0
      const width = 100 * (Math.abs(lastValueFormatted) / intervalLength) || 0;
      const widthWithUnit = (0, _last_value_utils.isEmptyValue)(lastValue) ? '1px' : `${width}%`;
      const label = item.label;
      return /*#__PURE__*/_react.default.createElement("tr", {
        key: key,
        onClick: this.handleClick({
          lastValue,
          ...item
        }),
        style: typeof this.props.onClick === 'function' ? {
          cursor: 'pointer'
        } : {}
      }, /*#__PURE__*/_react.default.createElement("td", {
        title: item.label,
        className: "tvbVisTopN__label",
        css: topNLabelStyle,
        style: {
          maxWidth: `${this.state.labelMaxWidth}px`
        }
      }, (0, _empty_label.getValueOrEmpty)(label)), /*#__PURE__*/_react.default.createElement("td", {
        width: "100%",
        className: "tvbVisTopN__bar",
        css: topNBarStyle
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisTopN__innerBar",
        css: topNInnerBarStyle,
        style: TopN.calcInnerBarStyles(renderMode, isPositiveValue)
      }, /*#__PURE__*/_react.default.createElement("div", {
        style: TopN.calcInnerBarDivStyles(item, widthWithUnit, isPositiveValue),
        "data-test-subj": "topNInnerBar"
      }))), /*#__PURE__*/_react.default.createElement("td", {
        className: "tvbVisTopN__value",
        css: topNValueStyle,
        "data-test-subj": "tsvbTopNValue"
      }, /*#__PURE__*/_react.default.createElement("span", {
        dangerouslySetInnerHTML: {
          __html: formatter(lastValue)
        }
      })));
    };
  }
  render() {
    if (!this.props.series) return null;
    const intervalSettings = this.props.series.reduce((acc, series, index) => {
      var _getLastValue;
      const value = (_getLastValue = (0, _last_value_utils.getLastValue)(series.data)) !== null && _getLastValue !== void 0 ? _getLastValue : 0;
      return {
        min: !index || value < acc.min ? value : acc.min,
        max: !index || value > acc.max ? value : acc.max
      };
    }, {
      min: undefined,
      max: undefined
    });
    const rows = this.props.series.map(this.renderRow(intervalSettings));
    let className = 'tvbVisTopN';
    if (this.props.reversed) {
      className += ' tvbVisTopN--reversed';
    }
    return /*#__PURE__*/_react.default.createElement(_render_counter.RenderCounter, {
      initialRender: this.props.initialRender
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: className,
      css: [topNContainerStyle, this.props.reversed && topNReversedStyles]
    }, /*#__PURE__*/_react.default.createElement("table", {
      className: "tvbVisTopN__table",
      "data-test-subj": "tvbVisTopNTable",
      ref: this.tableRef
    }, /*#__PURE__*/_react.default.createElement("tbody", null, rows))));
  }
}
exports.TopN = TopN;
(0, _defineProperty2.default)(TopN, "getRenderMode", (min, max) => {
  if (min >= 0) {
    return RENDER_MODES.POSITIVE;
  } else if (max < 0) {
    return RENDER_MODES.NEGATIVE;
  }
  return RENDER_MODES.MIXED;
});
(0, _defineProperty2.default)(TopN, "calcInnerBarStyles", (renderMode, isPositive) => {
  if (renderMode === RENDER_MODES.MIXED) {
    return {
      [isPositive ? 'marginLeft' : 'marginRight']: '50%'
    };
  }
  return {};
});
(0, _defineProperty2.default)(TopN, "calcInnerBarDivStyles", (item, widthWithUnit, isPositive) => {
  return {
    backgroundColor: item.color,
    width: widthWithUnit,
    float: isPositive ? 'left' : 'right'
  };
});
(0, _defineProperty2.default)(TopN, "calcDomain", (renderMode, min, max) => {
  if (renderMode === RENDER_MODES.MIXED) {
    return Math.max(max, Math.abs(min));
  } else if (renderMode === RENDER_MODES.NEGATIVE) {
    return Math.abs(min);
  }
  return max;
});
TopN.defaultProps = {
  tickFormatter: n => n,
  direction: 'desc'
};
TopN.propTypes = {
  tickFormatter: _propTypes.default.func,
  onClick: _propTypes.default.func,
  series: _propTypes.default.array,
  reversed: _propTypes.default.bool,
  direction: _propTypes.default.string
};