"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateDomainForSeries = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const calculateDomainForSeries = series => {
  var _series$;
  const seriesData = ((_series$ = series[0]) === null || _series$ === void 0 ? void 0 : _series$.data) || [];
  return seriesData !== null && seriesData !== void 0 && seriesData.length ? {
    domainStart: seriesData[0][0],
    domainEnd: seriesData[Math.max(seriesData.length - 1, 0)][0]
  } : undefined;
};
exports.calculateDomainForSeries = calculateDomainForSeries;