"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelConfig = PanelConfig;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _form_validation_context = require("../../contexts/form_validation_context");
var _vis_data_context = require("../../contexts/vis_data_context");
var _panel_model_context = require("../../contexts/panel_model_context");
var _timeseries = require("./timeseries");
var _metric = require("./metric");
var _top_n = require("./top_n");
var _table = require("./table");
var _gauge = require("./gauge");
var _markdown = require("./markdown");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const panelConfigTypes = {
  timeseries: _timeseries.TimeseriesPanelConfig,
  table: _table.TablePanelConfig,
  metric: _metric.MetricPanelConfig,
  top_n: _top_n.TopNPanelConfig,
  gauge: _gauge.GaugePanelConfig,
  markdown: _markdown.MarkdownPanelConfig
};
const checkModelValidity = validationResults => Object.values(validationResults).every(isValid => isValid);
function PanelConfig(props) {
  const {
    model,
    onChange
  } = props;
  const Component = panelConfigTypes[model.type];
  const formValidationResults = (0, _react.useRef)({});
  const [visData, setVisData] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    const visDataSubscription = props.visData$.subscribe((data = {}) => setVisData(data));
    return () => visDataSubscription.unsubscribe();
  }, [model.id, props.visData$]);
  const updateControlValidity = (0, _react.useCallback)((controlKey, isControlValid) => {
    formValidationResults.current[controlKey] = isControlValid;
    onChange({
      isModelInvalid: !checkModelValidity(formValidationResults.current)
    });
  }, [onChange]);
  if (Component) {
    return /*#__PURE__*/_react.default.createElement(_form_validation_context.FormValidationContext.Provider, {
      value: updateControlValidity
    }, /*#__PURE__*/_react.default.createElement(_panel_model_context.PanelModelContext.Provider, {
      value: model
    }, /*#__PURE__*/_react.default.createElement(_vis_data_context.VisDataContext.Provider, {
      value: visData
    }, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": `tvbPanelConfig__${model.type}`
    }, /*#__PURE__*/_react.default.createElement(Component, props)))));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.missingPanelConfigDescription",
    defaultMessage: "Missing panel config for \u201C{modelType}\u201D",
    values: {
      modelType: model.type
    }
  }));
}