"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../../services");
var _panel_model_context = require("../../../contexts/panel_model_context");
var _field_text_select = require("./field_text_select");
var _combo_box_select = require("./combo_box_select");
var _errors = require("../../../../../common/errors");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const queryAllIndicesHelpText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visTypeTimeseries.indexPatternSelect.queryAllIndicesText",
  defaultMessage: "To query all indices, use {asterisk}.",
  values: {
    asterisk: /*#__PURE__*/_react.default.createElement("strong", null, "*")
  }
});
const getIndexPatternHelpText = useKibanaIndices => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visTypeTimeseries.indexPatternSelect.defaultDataViewText",
  defaultMessage: "Using the default data view. {queryAllIndicesHelpText}",
  values: {
    queryAllIndicesHelpText: useKibanaIndices ? '' : queryAllIndicesHelpText
  }
});
const indexPatternLabel = _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.label', {
  defaultMessage: 'Data view'
});
const isFetchedIndexValid = f => f && !f.missedIndex;
const IndexPatternSelect = ({
  indexPatternName,
  onChange,
  disabled,
  fetchedIndex,
  allowIndexSwitchingMode
}) => {
  var _fetchedIndex$default, _fetchedIndex$default2;
  const htmlId = (0, _eui.htmlIdGenerator)();
  const panelModel = (0, _react.useContext)(_panel_model_context.PanelModelContext);
  const useKibanaIndices = Boolean(panelModel === null || panelModel === void 0 ? void 0 : panelModel[_constants.USE_KIBANA_INDEXES_KEY]);
  const Component = useKibanaIndices ? _combo_box_select.ComboBoxSelect : _field_text_select.FieldTextSelect;
  const onIndexChange = (0, _react.useCallback)(index => {
    onChange({
      [indexPatternName]: index
    });
  }, [indexPatternName, onChange]);
  const onModeChange = (0, _react.useCallback)((useKibanaIndexes, index) => {
    var _index$indexPattern;
    onChange({
      [_constants.USE_KIBANA_INDEXES_KEY]: useKibanaIndexes,
      [indexPatternName]: index !== null && index !== void 0 && (_index$indexPattern = index.indexPattern) !== null && _index$indexPattern !== void 0 && _index$indexPattern.id ? {
        id: index.indexPattern.id
      } : ''
    });
  }, [onChange, indexPatternName]);
  const navigateToCreateIndexPatternPage = (0, _react.useCallback)(() => {
    var _indexPatternString;
    const coreStart = (0, _services.getCoreStart)();
    coreStart.application.navigateToApp('management', {
      path: `/kibana/indexPatterns/create?name=${(_indexPatternString = fetchedIndex.indexPatternString) !== null && _indexPatternString !== void 0 ? _indexPatternString : ''}`
    });
  }, [fetchedIndex]);
  if (!fetchedIndex) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('indexPattern'),
    label: indexPatternLabel,
    helpText: fetchedIndex.defaultIndex && getIndexPatternHelpText(useKibanaIndices),
    isInvalid: !isFetchedIndexValid(fetchedIndex),
    error: fetchedIndex.missedIndex ? (0, _errors.getDataViewNotFoundError)(fetchedIndex.missedIndex) : undefined,
    labelAppend: !useKibanaIndices && fetchedIndex.indexPatternString && !fetchedIndex.indexPattern ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: navigateToCreateIndexPatternPage
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.indexPatternSelect.createDataViewText",
      defaultMessage: "Create data view"
    }))) : null
  }, /*#__PURE__*/_react.default.createElement(Component, {
    fetchedIndex: fetchedIndex,
    disabled: disabled,
    allowSwitchMode: allowIndexSwitchingMode,
    onIndexChange: onIndexChange,
    onModeChange: onModeChange,
    placeholder: (_fetchedIndex$default = (_fetchedIndex$default2 = fetchedIndex.defaultIndex) === null || _fetchedIndex$default2 === void 0 ? void 0 : _fetchedIndex$default2.getName()) !== null && _fetchedIndex$default !== void 0 ? _fetchedIndex$default : '',
    "data-test-subj": "metricsIndexPatternInput"
  }));
};
exports.IndexPatternSelect = IndexPatternSelect;