"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkIfNumericMetric = void 0;
var _public = require("@kbn/data-plugin/public");
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
var _enums = require("../../../../common/enums");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// this function checks if metric has numeric value result
const checkIfNumericMetric = (metric, fields, indexPattern) => {
  // currently only Top Hit could have not numeric value result
  if ((metric === null || metric === void 0 ? void 0 : metric.type) === _enums.TSVB_METRIC_TYPES.TOP_HIT) {
    var _fields$getIndexPatte;
    const selectedField = (_fields$getIndexPatte = fields[(0, _index_patterns_utils.getIndexPatternKey)(indexPattern)]) === null || _fields$getIndexPatte === void 0 ? void 0 : _fields$getIndexPatte.find(({
      name
    }) => name === (metric === null || metric === void 0 ? void 0 : metric.field));
    return (selectedField === null || selectedField === void 0 ? void 0 : selectedField.type) === _public.KBN_FIELD_TYPES.NUMBER;
  }
  return true;
};
exports.checkIfNumericMetric = checkIfNumericMetric;