"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SerialDiffAgg = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _agg_select = require("./agg_select");
var _metric_select = require("./metric_select");
var _agg_row = require("./agg_row");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _create_number_handler = require("../lib/create_number_handler");
var _enums = require("../../../../common/enums");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SERIAL_DIFF_DEFAULT_VALUE = 1;
const SerialDiffAgg = props => {
  const {
    siblings,
    fields,
    indexPattern,
    model
  } = props;
  const handleChange = (0, _create_change_handler.createChangeHandler)(props.onChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const handleNumberChange = (0, _create_number_handler.createNumberHandler)(handleChange);
  const htmlId = (0, _eui.htmlIdGenerator)();
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.serialDiff.aggregationLabel",
    defaultMessage: "Aggregation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('metric'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.serialDiff.metricLabel",
      defaultMessage: "Metric"
    })
  }, /*#__PURE__*/_react.default.createElement(_metric_select.MetricSelect, {
    onChange: handleSelectChange('field'),
    metrics: siblings,
    metric: model,
    fields: fields[(0, _index_patterns_utils.getIndexPatternKey)(indexPattern)],
    value: model.field,
    exclude: [_enums.TSVB_METRIC_TYPES.TOP_HIT]
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('lag'),
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.serialDiff.lagLabel",
      defaultMessage: "Lag",
      description: "'Lag' refers to the parameter name of the serial diff translation https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-pipeline-serialdiff-aggregation.html. This should only be translated if there is a reasaonable word explaining what that parameter does."
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.serialDiff.lagLabel.hint",
        defaultMessage: "The historical bucket to subtract from the current value. Must be a positive, non-zero integer"
      }),
      type: "question"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    placeholder: SERIAL_DIFF_DEFAULT_VALUE,
    onChange: handleNumberChange('lag', {
      isClearable: true
    }),
    value: model.lag,
    min: 1
  })))));
};
exports.SerialDiffAgg = SerialDiffAgg;
SerialDiffAgg.propTypes = {
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  indexPattern: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]),
  model: _propTypes.default.object,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  panel: _propTypes.default.object,
  series: _propTypes.default.object,
  siblings: _propTypes.default.array
};