"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentileRankValues = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _multi_value_row = require("./multi_value_row");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const PercentileRankValues = props => {
  const values = props.values || [];
  const colors = props.colors || [];
  const {
    onChange,
    disableAdd,
    disableDelete,
    showOnlyLastRow,
    enableColorPicker
  } = props;
  const onChangeValue = ({
    value,
    id,
    color
  }) => {
    values[id] = value;
    colors[id] = color;
    onChange(values, colors);
  };
  const onDeleteValue = ({
    id
  }) => onChange(values.filter((item, currentIndex) => id !== currentIndex), colors.filter((item, currentIndex) => id !== currentIndex));
  const onAddValue = () => onChange([...values, ''], [...colors, _constants.TSVB_DEFAULT_COLOR]);
  const renderRow = ({
    rowModel,
    disableDeleteRow,
    disableAddRow
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `percentileRankValue__item${rowModel.id}`
  }, /*#__PURE__*/_react.default.createElement(_multi_value_row.MultiValueRow, {
    onAdd: onAddValue,
    onChange: onChangeValue,
    onDelete: onDeleteValue,
    disableDelete: disableDeleteRow,
    disableAdd: disableAddRow,
    model: rowModel,
    enableColorPicker: enableColorPicker
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, showOnlyLastRow && renderRow({
    rowModel: {
      id: values.length - 1,
      value: (0, _lodash.last)(values) || '',
      color: (0, _lodash.last)(colors) || _constants.TSVB_DEFAULT_COLOR
    },
    disableAddRow: true,
    disableDeleteRow: true
  }), !showOnlyLastRow && values.map((value, id, array) => renderRow({
    rowModel: {
      id,
      value: value || '',
      color: colors[id] || _constants.TSVB_DEFAULT_COLOR
    },
    disableAddRow: disableAdd,
    disableDeleteRow: disableDelete || array.length < 2
  })));
};
exports.PercentileRankValues = PercentileRankValues;