"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggRow = AggRow;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _add_delete_buttons = require("../add_delete_buttons");
var _series_drag_handler = require("../series_drag_handler");
var _common = require("../../styles/common.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function AggRow(props) {
  let iconType = 'eyeClosed';
  let iconColor = 'subdued';
  const lastSibling = (0, _lodash.last)(props.siblings);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (lastSibling.id === props.model.id) {
    iconType = 'eye';
    iconColor = 'text';
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _common.tsvbEditorRowStyles)(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "aggRow",
    gutterSize: "s",
    alignItems: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    color: iconColor,
    css: {
      marginTop: euiTheme.size.xs
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _common.aggRowChildrenStyles)(euiTheme)
  }, props.children), /*#__PURE__*/_react.default.createElement(_series_drag_handler.SeriesDragHandler, {
    dragHandleProps: props.dragHandleProps,
    hideDragHandler: props.disableDelete
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
    testSubj: "addMetric",
    addTooltip: _i18n.i18n.translate('visTypeTimeseries.aggRow.addMetricButtonTooltip', {
      defaultMessage: 'Add Metric'
    }),
    deleteTooltip: _i18n.i18n.translate('visTypeTimeseries.aggRow.deleteMetricButtonTooltip', {
      defaultMessage: 'Delete Metric'
    }),
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    disableDelete: props.disableDelete
  }))));
}