"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfiguration = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getConfiguration = (layerId, params, palette, {
  metrics,
  buckets,
  columnsWithoutReferenced,
  bucketCollapseFn
}) => {
  const [metricAccessor] = metrics;
  const [breakdownByAccessor] = buckets.all;
  const collapseFn = bucketCollapseFn ? Object.keys(bucketCollapseFn).find(key => bucketCollapseFn[key].includes(breakdownByAccessor)) : undefined;
  return {
    layerId,
    layerType: 'data',
    palette: params.metric.metricColorMode !== 'None' ? palette : undefined,
    metricAccessor,
    breakdownByAccessor,
    collapseFn
  };
};
exports.getConfiguration = getConfiguration;