"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/ui-actions-plugin/public");
var _markdown_vis = require("./markdown_vis");
var _markdown_fn = require("./markdown_fn");
var _markdown_renderer = require("./markdown_renderer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/** @internal */
class MarkdownPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initializerContext", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    expressions,
    visualizations
  }) {
    visualizations.createBaseVisualization(_markdown_vis.markdownVisType);
    expressions.registerRenderer((0, _markdown_renderer.getMarkdownVisRenderer)({
      getStartDeps: core.getStartServices
    }));
    expressions.registerFunction(_markdown_fn.createMarkdownVisFn);
  }
  start(core, deps) {
    deps.uiActions.registerActionAsync('addMarkdownAction', async () => {
      const {
        getAddMarkdownPanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_markdown_panel_action')));
      return getAddMarkdownPanelAction(deps);
    });
    deps.uiActions.attachAction(_public.ADD_PANEL_TRIGGER, 'addMarkdownAction');
  }
}
exports.MarkdownPlugin = MarkdownPlugin;