"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddMarkdownPanelAction = getAddMarkdownPanelAction;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/embeddable-plugin/public");
var _markdown_vis = require("./markdown_vis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getAddMarkdownPanelAction(deps) {
  return {
    id: 'addMarkdownPanelAction',
    getIconType: () => _markdown_vis.markdownVisType.icon,
    order: _markdown_vis.markdownVisType.order,
    isCompatible: async () => true,
    execute: async ({
      embeddable
    }) => {
      var _embeddable$getAppCon, _embeddable$getAppCon2;
      const stateTransferService = deps.embeddable.getStateTransfer();
      stateTransferService.navigateToEditor('visualize', {
        path: '#/create?type=markdown',
        state: {
          originatingApp: (0, _presentationPublishing.apiHasAppContext)(embeddable) ? embeddable.getAppContext().currentAppId : '',
          originatingPath: (0, _presentationPublishing.apiHasAppContext)(embeddable) ? (_embeddable$getAppCon = (_embeddable$getAppCon2 = embeddable.getAppContext()).getCurrentPath) === null || _embeddable$getAppCon === void 0 ? void 0 : _embeddable$getAppCon.call(_embeddable$getAppCon2) : undefined,
          searchSessionId: deps.data.search.session.getSessionId()
        }
      });
    },
    grouping: [_public.ADD_PANEL_ANNOTATION_GROUP],
    getDisplayName: () => _markdown_vis.markdownVisType.titleInWizard,
    getDisplayNameTooltip: () => _markdown_vis.markdownVisType.description
  };
}