"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/charts-plugin/public");
var _public3 = require("@kbn/visualizations-plugin/public");
var _labels_panel = require("./labels_panel");
var _collections = require("../collections");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const HeatmapOptions = props => {
  var _stateParams$truncate, _stateParams$maxLegen;
  const {
    stateParams,
    uiState,
    setValue,
    setValidity,
    setTouched,
    showElasticChartsOptions
  } = props;
  const [valueAxis] = stateParams.valueAxes;
  const isColorsNumberInvalid = +stateParams.colorsNumber < 2 || +stateParams.colorsNumber > 10;
  const [isColorRangesValid, setIsColorRangesValid] = (0, _react.useState)(false);
  const legendSize = stateParams.legendSize;
  const [hadAutoLegendSize] = (0, _react.useState)(() => legendSize === _public3.LegendSize.AUTO);
  const setValueAxisScale = (0, _react.useCallback)((paramName, value) => setValue('valueAxes', [{
    ...valueAxis,
    scale: {
      ...valueAxis.scale,
      [paramName]: value
    }
  }]), [valueAxis, setValue]);
  (0, _react.useEffect)(() => {
    setValidity(stateParams.setColorRange ? isColorRangesValid : !isColorsNumberInvalid);
  }, [stateParams.setColorRange, isColorRangesValid, isColorsNumberInvalid, setValidity]);
  (0, _react.useEffect)(() => {
    if (stateParams.setColorRange) {
      stateParams.percentageMode = false;
    }
  }, [stateParams]);
  const handleLegendSizeChange = (0, _react.useCallback)(size => setValue('legendSize', size), [setValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeHeatmap.editors.heatmap.basicSettingsTitle",
    defaultMessage: "Basic settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.BasicOptions, (0, _extends2.default)({}, props, {
    legendPositions: _collections.legendPositions
  })), showElasticChartsOptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.LongLegendOptions, {
    "data-test-subj": "heatmapLongLegendsOptions",
    truncateLegend: (_stateParams$truncate = stateParams.truncateLegend) !== null && _stateParams$truncate !== void 0 ? _stateParams$truncate : true,
    maxLegendLines: (_stateParams$maxLegen = stateParams.maxLegendLines) !== null && _stateParams$maxLegen !== void 0 ? _stateParams$maxLegen : 1,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_public.LegendSizeSettings, {
    legendSize: legendSize,
    onLegendSizeChange: handleLegendSizeChange,
    isVerticalLegend: stateParams.legendPosition === _charts.Position.Left || stateParams.legendPosition === _charts.Position.Right,
    showAutoOption: hadAutoLegendSize
  })), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeHeatmap.editors.heatmap.highlightLabel', {
      defaultMessage: 'Highlight range'
    }),
    "data-test-subj": "heatmapHighlightRange",
    paramName: "enableHover",
    value: stateParams.enableHover,
    setValue: setValue,
    tooltip: showElasticChartsOptions ? _i18n.i18n.translate('visTypeHeatmap.editors.heatmap.highlightLabelTooltipNotAvailable', {
      defaultMessage: 'Highlight hovered range is not yet supported with the new charts library. Please enable the heatmap legacy charts library advanced setting .'
    }) : _i18n.i18n.translate('visTypeHeatmap.editors.heatmap.highlightLabelTooltip', {
      defaultMessage: 'Highlight hovered range in the chart and corresponding label in the legend.'
    }),
    disabled: showElasticChartsOptions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeHeatmap.editors.heatmap.heatmapSettingsTitle",
    defaultMessage: "Heatmap settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.ColorSchemaOptions, {
    colorSchema: stateParams.colorSchema,
    colorSchemas: _public2.colorSchemas,
    invertColors: stateParams.invertColors,
    uiState: uiState,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: showElasticChartsOptions ? _i18n.i18n.translate('visTypeHeatmap.editors.heatmap.colorScaleTooltipNotAvailable', {
      defaultMessage: 'Color scale is not supported with the new charts library. Please enable the heatmap legacy charts library advanced setting.'
    }) : null,
    delay: "long",
    position: "right"
  }, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypeHeatmap.controls.heatmapOptions.colorScaleLabel', {
      defaultMessage: 'Color scale'
    }),
    options: _collections.scaleTypes,
    paramName: "type",
    value: valueAxis.scale.type,
    setValue: setValueAxisScale,
    disabled: showElasticChartsOptions,
    "data-test-subj": "heatmapColorScale"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !showElasticChartsOptions && /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeHeatmap.controls.heatmapOptions.scaleToDataBoundsLabel', {
      defaultMessage: 'Scale to data bounds'
    }),
    paramName: "defaultYExtents",
    value: valueAxis.scale.defaultYExtents,
    setValue: setValueAxisScale,
    "data-test-subj": "heatmapScaleToDataBounds"
  }), /*#__PURE__*/_react.default.createElement(_public.PercentageModeOption, {
    "data-test-subj": "metricPercentageMode",
    percentageMode: stateParams.setColorRange ? false : stateParams.percentageMode,
    disabled: stateParams.setColorRange,
    formatPattern: stateParams.percentageFormatPattern,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.NumberInputOption, {
    "data-test-subj": "heatmapColorsNumber",
    disabled: stateParams.setColorRange,
    isInvalid: isColorsNumberInvalid,
    label: _i18n.i18n.translate('visTypeHeatmap.controls.heatmapOptions.colorsNumberLabel', {
      defaultMessage: 'Number of colors'
    }),
    max: 10,
    min: 2,
    paramName: "colorsNumber",
    value: stateParams.colorsNumber,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    "data-test-subj": "heatmapUseCustomRanges",
    label: _i18n.i18n.translate('visTypeHeatmap.controls.heatmapOptions.useCustomRangesLabel', {
      defaultMessage: 'Use custom ranges'
    }),
    paramName: "setColorRange",
    value: stateParams.setColorRange,
    setValue: setValue
  }), stateParams.setColorRange && stateParams.colorsRange && /*#__PURE__*/_react.default.createElement(_public.ColorRanges, {
    "data-test-subj": "heatmapColorRange",
    colorsRange: stateParams.colorsRange,
    setValue: setValue,
    setTouched: setTouched,
    setValidity: setIsColorRangesValid
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_labels_panel.LabelsPanel, {
    valueAxis: valueAxis,
    setValue: setValue,
    isNewLibrary: showElasticChartsOptions
  }));
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = HeatmapOptions;
module.exports = exports.default;