"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfiguration = void 0;
var _to_ast = require("../../to_ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getConfiguration = (layerId, params, palette, {
  metricAccessor,
  minAccessor,
  maxAccessor
}) => {
  return {
    ...(0, _to_ast.getDefaultGaugeArgsFromParams)(params.gauge),
    layerId,
    layerType: 'data',
    palette,
    metricAccessor,
    minAccessor,
    maxAccessor,
    colorMode: palette ? 'palette' : 'none'
  };
};
exports.getConfiguration = getConfiguration;