"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HasExtendedBoundsParamEditor = HasExtendedBoundsParamEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _switch = require("./switch");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const {
  isType
} = _public.search.aggs;
function HasExtendedBoundsParamEditor(props) {
  const {
    agg,
    setValue,
    value
  } = props;
  const minDocCount = (0, _react.useRef)(agg.params.min_doc_count);
  (0, _react.useEffect)(() => {
    if (minDocCount.current !== agg.params.min_doc_count) {
      // The "Extend bounds" param is only enabled when "Show empty buckets" is turned on.
      // So if "Show empty buckets" is changed, "Extend bounds" should reflect changes
      minDocCount.current = agg.params.min_doc_count;
      setValue(value && agg.params.min_doc_count);
    }
  }, [agg.params.min_doc_count, setValue, value]);
  return /*#__PURE__*/_react.default.createElement(_switch.SwitchParamEditor, (0, _extends2.default)({}, props, {
    displayLabel: _i18n.i18n.translate('visDefaultEditor.controls.extendedBoundsLabel', {
      defaultMessage: 'Extend bounds'
    }),
    displayToolTip: _i18n.i18n.translate('visDefaultEditor.controls.extendedBoundsTooltip', {
      defaultMessage: 'Min and Max do not filter the results, but rather extend the bounds of the result set.'
    }),
    disabled: !props.agg.params.min_doc_count || !(isType('number')(props.agg) || isType('date')(props.agg))
  }));
}