"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateRangesParamEditor = DateRangesParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FROM_PLACEHOLDER = '\u2212\u221E';
const TO_PLACEHOLDER = '+\u221E';
const generateId = (0, _eui.htmlIdGenerator)();
const validateDateMath = (value = '') => {
  if (!value) {
    return true;
  }
  const moment = _datemath.default.parse(value);
  return moment && moment.isValid();
};
function DateRangesParamEditor({
  value = [],
  setValue,
  setValidity
}) {
  const {
    services
  } = (0, _public.useKibana)();
  const [ranges, setRanges] = (0, _react.useState)(() => value.map(range => ({
    ...range,
    id: generateId()
  })));
  const hasInvalidRange = value.some(({
    from,
    to
  }) => !from && !to || !validateDateMath(from) || !validateDateMath(to));
  const updateRanges = (0, _react.useCallback)(rangeValues => {
    // do not set internal id parameter into saved object
    setValue(rangeValues.map(range => (0, _lodash.omit)(range, 'id')));
    setRanges(rangeValues);
  }, [setValue]);
  const onAddRange = (0, _react.useCallback)(() => updateRanges([...ranges, {
    id: generateId()
  }]), [ranges, updateRanges]);
  (0, _useMount.default)(() => {
    // set up an initial range when there is no default range
    if (!value.length) {
      onAddRange();
    }
  });
  (0, _react.useEffect)(() => {
    // responsible for discarding changes
    if (value.length !== ranges.length || value.some((range, index) => !(0, _lodash.isEqual)(range, (0, _lodash.omit)(ranges[index], 'id')))) {
      setRanges(value.map(range => ({
        ...range,
        id: generateId()
      })));
    }
  }, [ranges, value]);
  (0, _react.useEffect)(() => {
    setValidity(!hasInvalidRange);
  }, [hasInvalidRange, setValidity]);
  const onRemoveRange = id => updateRanges(ranges.filter(range => range.id !== id));
  const onChangeRange = (id, key, newValue) => updateRanges(ranges.map(range => range.id === id ? {
    ...range,
    [key]: newValue === '' ? undefined : newValue
  } : range));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: services.docLinks.links.date.dateMath,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.dateRanges.acceptedDateFormatsLinkText",
    defaultMessage: "Acceptable date formats"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), ranges.map(({
    from,
    to,
    id
  }, index) => {
    const deleteBtnTitle = _i18n.i18n.translate('visDefaultEditor.controls.dateRanges.removeRangeButtonAriaLabel', {
      defaultMessage: 'Remove the range of {from} to {to}',
      values: {
        from: from || FROM_PLACEHOLDER,
        to: to || TO_PLACEHOLDER
      }
    });
    const areBothEmpty = !from && !to;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "aria-label": _i18n.i18n.translate('visDefaultEditor.controls.dateRanges.fromColumnLabel', {
        defaultMessage: 'From',
        description: 'Beginning of a date range, e.g. *From* 2018-02-26 To 2018-02-28'
      }),
      compressed: true,
      fullWidth: true,
      isInvalid: areBothEmpty || !validateDateMath(from),
      placeholder: FROM_PLACEHOLDER,
      value: from || '',
      onChange: ev => onChangeRange(id, 'from', ev.target.value),
      "data-test-subj": `visEditorDateRange${index}__from`
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortRight",
      color: "subdued"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "aria-label": _i18n.i18n.translate('visDefaultEditor.controls.dateRanges.toColumnLabel', {
        defaultMessage: 'To',
        description: 'End of a date range, e.g. From 2018-02-26 *To* 2018-02-28'
      }),
      "data-test-subj": `visEditorDateRange${index}__to`,
      compressed: true,
      fullWidth: true,
      isInvalid: areBothEmpty || !validateDateMath(to),
      placeholder: TO_PLACEHOLDER,
      value: to || '',
      onChange: ev => onChangeRange(id, 'to', ev.target.value)
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      title: deleteBtnTitle,
      "aria-label": deleteBtnTitle,
      disabled: value.length === 1,
      color: "danger",
      iconType: "trash",
      onClick: () => onRemoveRange(id)
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }));
  }), hasInvalidRange && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.dateRanges.errorMessage",
    defaultMessage: "Each range should have at least one valid date."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAddRange,
    size: "xs",
    "data-test-subj": "visEditorAddDateRange"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.dateRanges.addRangeButtonLabel",
    defaultMessage: "Add range"
  })))));
}