"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGGS_ACTION_KEYS = void 0;
exports.aggGroupReducer = aggGroupReducer;
exports.initAggsState = initAggsState;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let AGGS_ACTION_KEYS = exports.AGGS_ACTION_KEYS = /*#__PURE__*/function (AGGS_ACTION_KEYS) {
  AGGS_ACTION_KEYS["TOUCHED"] = "aggsTouched";
  AGGS_ACTION_KEYS["VALID"] = "aggsValid";
  return AGGS_ACTION_KEYS;
}({});
function aggGroupReducer(state, action) {
  const aggState = state[action.aggId] || {
    touched: false,
    valid: true
  };
  switch (action.type) {
    case AGGS_ACTION_KEYS.TOUCHED:
      return {
        ...state,
        [action.aggId]: {
          ...aggState,
          touched: action.payload
        }
      };
    case AGGS_ACTION_KEYS.VALID:
      return {
        ...state,
        [action.aggId]: {
          ...aggState,
          valid: action.payload
        }
      };
    default:
      throw new Error();
  }
}
function initAggsState(group) {
  return group.reduce((state, agg) => {
    state[agg.id] = {
      touched: false,
      valid: true
    };
    return state;
  }, {});
}