"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAggRemovable = exports.getEnabledMetricAggsCount = exports.calcAggIsTooLow = void 0;
exports.isInvalidAggsTouched = isInvalidAggsTouched;
var _lodash = require("lodash");
var _schemas = require("../schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isAggRemovable = (agg, group, schemas) => {
  const schema = (0, _schemas.getSchemaByName)(schemas, agg.schema);
  const metricCount = group.reduce((count, aggregation) => aggregation.schema === agg.schema ? ++count : count, 0);
  // make sure the the number of these aggs is above the min
  return metricCount > schema.min;
};
exports.isAggRemovable = isAggRemovable;
const getEnabledMetricAggsCount = group => {
  return group.reduce((count, aggregation) => aggregation.schema === 'metric' && aggregation.enabled ? ++count : count, 0);
};
exports.getEnabledMetricAggsCount = getEnabledMetricAggsCount;
const calcAggIsTooLow = (agg, aggIndex, group, schemas) => {
  const schema = (0, _schemas.getSchemaByName)(schemas, agg.schema);
  if (!schema.mustBeFirst) {
    return false;
  }
  const firstDifferentSchema = (0, _lodash.findIndex)(group, aggr => {
    return aggr.schema !== agg.schema;
  });
  if (firstDifferentSchema === -1) {
    return false;
  }
  return aggIndex > firstDifferentSchema;
};
exports.calcAggIsTooLow = calcAggIsTooLow;
function isInvalidAggsTouched(aggsState) {
  const invalidAggs = Object.values(aggsState).filter(agg => !agg.valid);
  if ((0, _lodash.isEmpty)(invalidAggs)) {
    return false;
  }
  return invalidAggs.every(agg => agg.touched);
}