"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.urlSearchQuery = urlSearchQuery;
var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");
var _projections = require("./projections");
var _call_date_math = require("./call_date_math");
var _merge_projection = require("../../../common/utils/merge_projection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function urlSearchQuery(restFilters, uxQuery, searchValue) {
  const setup = {
    uiFilters: restFilters ? restFilters : {}
  };
  const projection = (0, _projections.getRumPageLoadTransactionsProjection)({
    setup,
    urlQuery: searchValue,
    ...uxQuery,
    start: (0, _call_date_math.callDateMath)(uxQuery === null || uxQuery === void 0 ? void 0 : uxQuery.start),
    end: (0, _call_date_math.callDateMath)(uxQuery === null || uxQuery === void 0 ? void 0 : uxQuery.end)
  });
  const params = (0, _merge_projection.mergeProjection)(projection, {
    body: {
      size: 0,
      aggs: {
        totalUrls: {
          cardinality: {
            field: _elasticsearch_fieldnames.TRANSACTION_URL
          }
        },
        urls: {
          terms: {
            field: _elasticsearch_fieldnames.TRANSACTION_URL,
            size: 10
          },
          aggs: {
            medianPLD: {
              percentiles: {
                field: _elasticsearch_fieldnames.TRANSACTION_DURATION,
                percents: [Number(uxQuery === null || uxQuery === void 0 ? void 0 : uxQuery.percentile)]
              }
            }
          }
        }
      }
    }
  });
  return params;
}