"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PERCENTILE_DEFAULT = void 0;
exports.inpQuery = inpQuery;
exports.transformINPResponse = transformINPResponse;
var _core_web_vitals_query = require("./core_web_vitals_query");
var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");
var _merge_projection = require("../../../common/utils/merge_projection");
var _projections = require("./projections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformINPResponse(response, percentile = PERCENTILE_DEFAULT) {
  var _response$aggregation, _getRanksPercentages;
  if (!response) return response;
  const {
    inp,
    inpRanks
  } = (_response$aggregation = response.aggregations) !== null && _response$aggregation !== void 0 ? _response$aggregation : {};
  const pkey = percentile.toFixed(1);
  return {
    hasINP: response.hits.total.value > 0,
    inp: inp === null || inp === void 0 ? void 0 : inp.values[pkey],
    inpRanks: inp !== null && inp !== void 0 && inp.values[pkey] ? (_getRanksPercentages = (0, _core_web_vitals_query.getRanksPercentages)(inpRanks === null || inpRanks === void 0 ? void 0 : inpRanks.values)) !== null && _getRanksPercentages !== void 0 ? _getRanksPercentages : _core_web_vitals_query.DEFAULT_RANKS : _core_web_vitals_query.DEFAULT_RANKS
  };
}
const PERCENTILE_DEFAULT = exports.PERCENTILE_DEFAULT = 50;
function inpQuery(start, end, urlQuery, uiFilters, percentile = PERCENTILE_DEFAULT) {
  const setup = {
    uiFilters: uiFilters !== null && uiFilters !== void 0 ? uiFilters : {}
  };
  const projection = (0, _projections.getRumPageExitTransactionsProjection)({
    setup,
    urlQuery,
    start,
    end
  });
  return (0, _merge_projection.mergeProjection)(projection, {
    body: {
      size: 0,
      query: {
        bool: {
          filter: [...projection.body.query.bool.filter]
        }
      },
      aggs: {
        inp: {
          percentiles: {
            field: _elasticsearch_fieldnames.INP_FIELD,
            percents: [percentile]
          }
        },
        inpRanks: {
          percentile_ranks: {
            field: _elasticsearch_fieldnames.INP_FIELD,
            values: [200, 500],
            keyed: false
          }
        }
      }
    }
  });
}