"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UxPlugin = void 0;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function getDataStartPlugin(core) {
  const [_, startPlugins] = await core.getStartServices();
  return startPlugins.data;
}
class UxPlugin {
  constructor(initContext) {
    this.initContext = initContext;
  }
  setup(core, plugins) {
    const pluginSetupDeps = plugins;
    if (plugins.observability) {
      const getUxDataHelper = async () => {
        const {
          fetchUxOverviewDate,
          hasRumData,
          createCallApmApi
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/app/rum_dashboard/ux_overview_fetchers')));
        // have to do this here as well in case app isn't mounted yet
        createCallApmApi(core);
        return {
          fetchUxOverviewDate,
          hasRumData
        };
      };
      plugins.observability.dashboard.register({
        appName: _deeplinksObservability.OBLT_UX_APP_ID,
        hasData: async params => {
          const dataHelper = await getUxDataHelper();
          const dataStartPlugin = await getDataStartPlugin(core);
          return dataHelper.hasRumData({
            ...params,
            dataStartPlugin
          });
        },
        fetchData: async params => {
          const dataStartPlugin = await getDataStartPlugin(core);
          const dataHelper = await getUxDataHelper();
          return dataHelper.fetchUxOverviewDate({
            ...params,
            dataStartPlugin
          });
        }
      });
      plugins.exploratoryView.register({
        appName: _deeplinksObservability.OBLT_UX_APP_ID,
        hasData: async params => {
          const dataHelper = await getUxDataHelper();
          const dataStartPlugin = await getDataStartPlugin(core);
          return dataHelper.hasRumData({
            ...params,
            dataStartPlugin
          });
        },
        fetchData: async params => {
          const dataStartPlugin = await getDataStartPlugin(core);
          const dataHelper = await getUxDataHelper();
          return dataHelper.fetchUxOverviewDate({
            ...params,
            dataStartPlugin
          });
        }
      });
    }

    // register observability nav if user has access to plugin
    plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(core.getStartServices()).pipe((0, _rxjs.map)(([coreStart]) => {
      // checking apm capability, since ux for now doesn't have it's
      // own capability
      if (coreStart.application.capabilities.apm.show) {
        return [
        // UX navigation
        {
          label: 'User Experience',
          sortKey: 600,
          entries: [{
            label: _i18n.i18n.translate('xpack.ux.overview.heading', {
              defaultMessage: 'Dashboard'
            }),
            app: _deeplinksObservability.OBLT_UX_APP_ID,
            path: '/',
            matchFullPath: true,
            ignoreTrailingSlash: true
          }]
        }];
      }
      return [];
    })));
    const isDev = this.initContext.env.mode.dev;
    core.application.register({
      id: _deeplinksObservability.OBLT_UX_APP_ID,
      title: 'User Experience',
      order: 8500,
      euiIconType: 'logoObservability',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      keywords: ['RUM', 'Real User Monitoring', 'DEM', 'Digital Experience Monitoring', 'EUM', 'End User Monitoring', 'UX', 'Javascript', 'APM', 'Mobile', 'digital', 'performance', 'web performance', 'web perf'],
      async mount(appMountParameters) {
        var _spaces;
        // Load application bundle and Get start service
        const [{
          renderApp
        }, [coreStart, corePlugins]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application/ux_app'))), core.getStartServices()]);
        const activeSpace = await ((_spaces = corePlugins.spaces) === null || _spaces === void 0 ? void 0 : _spaces.getActiveSpace());
        return renderApp({
          isDev,
          core: coreStart,
          deps: pluginSetupDeps,
          appMountParameters,
          corePlugins: corePlugins,
          spaceId: (activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.id) || 'default'
        });
      }
    });
  }
  start(core, plugins) {}
}
exports.UxPlugin = UxPlugin;