"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_AGENT_OS = exports.USER_AGENT_NAME = exports.USER_AGENT_DEVICE = exports.URL_FULL = exports.TRANSACTION_URL = exports.TRANSACTION_TYPE = exports.TRANSACTION_TIME_TO_FIRST_BYTE = exports.TRANSACTION_RESULT = exports.TRANSACTION_NAME = exports.TRANSACTION_ID = exports.TRANSACTION_DURATION = exports.TRANSACTION_DOM_INTERACTIVE = exports.TBT_FIELD = exports.SERVICE_NAME = exports.SERVICE_LANGUAGE_NAME = exports.SERVICE_ENVIRONMENT = exports.SERVICE = exports.PROCESSOR_EVENT = exports.LCP_FIELD = exports.INP_FIELD = exports.FCP_FIELD = exports.ERROR_GROUP_ID = exports.ERROR_EXC_TYPE = exports.ERROR_EXC_MESSAGE = exports.CLS_FIELD = exports.CLIENT_GEO_COUNTRY_ISO_CODE = exports.CLIENT_GEO = exports.AGENT_VERSION = exports.AGENT_NAME = exports.AGENT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SERVICE = exports.SERVICE = 'service';
const SERVICE_NAME = exports.SERVICE_NAME = 'service.name';
const SERVICE_ENVIRONMENT = exports.SERVICE_ENVIRONMENT = 'service.environment';
const AGENT = exports.AGENT = 'agent';
const AGENT_NAME = exports.AGENT_NAME = 'agent.name';
const AGENT_VERSION = exports.AGENT_VERSION = 'agent.version';
const ERROR_EXC_MESSAGE = exports.ERROR_EXC_MESSAGE = 'error.exception.message';
const ERROR_EXC_TYPE = exports.ERROR_EXC_TYPE = 'error.exception.type';
const ERROR_GROUP_ID = exports.ERROR_GROUP_ID = 'error.grouping_key';
const PROCESSOR_EVENT = exports.PROCESSOR_EVENT = 'processor.event';
const URL_FULL = exports.URL_FULL = 'url.full';
const USER_AGENT_NAME = exports.USER_AGENT_NAME = 'user_agent.name';
const SERVICE_LANGUAGE_NAME = exports.SERVICE_LANGUAGE_NAME = 'service.language.name';
const TRANSACTION_DURATION = exports.TRANSACTION_DURATION = 'transaction.duration.us';
const TRANSACTION_TYPE = exports.TRANSACTION_TYPE = 'transaction.type';
const TRANSACTION_RESULT = exports.TRANSACTION_RESULT = 'transaction.result';
const TRANSACTION_NAME = exports.TRANSACTION_NAME = 'transaction.name';
const TRANSACTION_ID = exports.TRANSACTION_ID = 'transaction.id';
const CLIENT_GEO_COUNTRY_ISO_CODE = exports.CLIENT_GEO_COUNTRY_ISO_CODE = 'client.geo.country_iso_code';

// RUM Labels
const TRANSACTION_URL = exports.TRANSACTION_URL = 'url.full';
const CLIENT_GEO = exports.CLIENT_GEO = 'client.geo';
const USER_AGENT_DEVICE = exports.USER_AGENT_DEVICE = 'user_agent.device.name';
const USER_AGENT_OS = exports.USER_AGENT_OS = 'user_agent.os.name';
const TRANSACTION_TIME_TO_FIRST_BYTE = exports.TRANSACTION_TIME_TO_FIRST_BYTE = 'transaction.marks.agent.timeToFirstByte';
const TRANSACTION_DOM_INTERACTIVE = exports.TRANSACTION_DOM_INTERACTIVE = 'transaction.marks.agent.domInteractive';
const FCP_FIELD = exports.FCP_FIELD = 'transaction.marks.agent.firstContentfulPaint';
const LCP_FIELD = exports.LCP_FIELD = 'transaction.marks.agent.largestContentfulPaint';
const TBT_FIELD = exports.TBT_FIELD = 'transaction.experience.tbt';
const CLS_FIELD = exports.CLS_FIELD = 'transaction.experience.cls';
const INP_FIELD = exports.INP_FIELD = 'numeric_labels.inp_value';