"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kibanaService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _api_service = require("../api_service/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class KibanaService {
  get core() {
    return this._core;
  }
  set core(coreStart) {
    this._core = coreStart;
    _api_service.apiService.http = this._core.http;
  }
  get startPlugins() {
    return this._startPlugins;
  }
  set startPlugins(startPlugins) {
    this._startPlugins = startPlugins;
  }
  get theme() {
    return this._theme;
  }
  set theme(coreTheme) {
    this._theme = coreTheme;
  }
  get toasts() {
    return this._core.notifications.toasts;
  }
  constructor() {
    (0, _defineProperty2.default)(this, "_core", void 0);
    (0, _defineProperty2.default)(this, "_startPlugins", void 0);
    (0, _defineProperty2.default)(this, "_theme", void 0);
  }
  static getInstance() {
    if (!KibanaService.instance) {
      KibanaService.instance = new KibanaService();
    }
    return KibanaService.instance;
  }
}
(0, _defineProperty2.default)(KibanaService, "instance", void 0);
const kibanaService = exports.kibanaService = KibanaService.getInstance();