"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asyncInitState = asyncInitState;
exports.handleAsyncAction = handleAsyncAction;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function handleAsyncAction(storeKey, asyncAction) {
  return {
    [String(asyncAction.get)]: state => ({
      ...state,
      [storeKey]: {
        ...state[storeKey],
        loading: true
      }
    }),
    [String(asyncAction.success)]: (state, action) => {
      return {
        ...state,
        [storeKey]: {
          ...state[storeKey],
          data: action.payload,
          loading: false
        }
      };
    },
    [String(asyncAction.fail)]: (state, action) => ({
      ...state,
      [storeKey]: {
        ...state[storeKey],
        data: null,
        error: action.payload,
        loading: false
      }
    })
  };
}
function asyncInitState(initialData = null) {
  return {
    data: initialData,
    loading: false,
    error: null
  };
}