"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.journeyReducer = void 0;
var _reduxActions = require("redux-actions");
var _journey = require("../actions/journey");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {};
const journeyReducer = exports.journeyReducer = (0, _reduxActions.handleActions)({
  [String(_journey.getJourneySteps)]: (state, {
    payload: {
      checkGroup
    }
  }) => ({
    ...state,
    // add an empty entry while fetching the check group,
    // or update the previously-loaded entry to a new loading state
    [checkGroup]: state[checkGroup] ? {
      ...state[checkGroup],
      loading: true
    } : {
      checkGroup,
      steps: [],
      loading: true
    }
  }),
  [String(_journey.getJourneyStepsSuccess)]: (state, {
    payload: {
      checkGroup,
      steps,
      details
    }
  }) => ({
    ...state,
    [checkGroup]: {
      loading: false,
      checkGroup,
      steps,
      details
    }
  }),
  [String(_journey.getJourneyStepsFail)]: (state, {
    payload: {
      checkGroup,
      error
    }
  }) => ({
    ...state,
    [checkGroup]: state[checkGroup] ? {
      ...state[checkGroup],
      loading: false,
      error
    } : {
      checkGroup,
      loading: false,
      steps: [],
      error
    }
  }),
  [String(_journey.pruneJourneyState)]: (state, action) => action.payload.reduce((prev, cur) => ({
    ...prev,
    [cur]: state[cur]
  }), {})
}, initialState);