"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchMLJobEffect = fetchMLJobEffect;
var _effects = require("redux-saga/effects");
var _actions = require("../actions");
var _fetch_effect = require("./fetch_effect");
var _ml_anomaly = require("../api/ml_anomaly");
var _alerts = require("../alerts/alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchMLJobEffect() {
  yield (0, _effects.takeLatest)(_actions.getExistingMLJobAction.get, (0, _fetch_effect.fetchEffectFactory)(_ml_anomaly.getExistingJobs, _actions.getExistingMLJobAction.success, _actions.getExistingMLJobAction.fail));
  yield (0, _effects.takeLatest)(_actions.createMLJobAction.get, (0, _fetch_effect.fetchEffectFactory)(_ml_anomaly.createMLJob, _actions.createMLJobAction.success, _actions.createMLJobAction.fail));
  yield (0, _effects.takeLatest)(_actions.getAnomalyRecordsAction.get, (0, _fetch_effect.fetchEffectFactory)(_ml_anomaly.fetchAnomalyRecords, _actions.getAnomalyRecordsAction.success, _actions.getAnomalyRecordsAction.fail));
  yield (0, _effects.takeLatest)(String(_actions.deleteMLJobAction.get), function* (action) {
    try {
      const response = yield (0, _effects.call)(_ml_anomaly.deleteMLJob, action.payload);
      yield (0, _effects.put)(_actions.deleteMLJobAction.success(response));

      // let's delete alert as well if it's there
      const {
        data: anomalyAlert
      } = yield (0, _effects.select)(_alerts.anomalyAlertSelector);
      if (anomalyAlert) {
        yield (0, _effects.put)(_alerts.deleteAlertAction.get({
          alertId: anomalyAlert.id
        }));
      }
    } catch (err) {
      yield (0, _effects.put)(_actions.deleteMLJobAction.fail(err));
    }
  });
  yield (0, _effects.takeLatest)(_actions.getMLCapabilitiesAction.get, (0, _fetch_effect.fetchEffectFactory)(_ml_anomaly.getMLCapabilities, _actions.getMLCapabilitiesAction.success, _actions.getMLCapabilitiesAction.fail));
}