"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _Either = require("fp-ts/lib/Either");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _public = require("@kbn/observability-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ApiService {
  get http() {
    return this._http;
  }
  set http(httpSetup) {
    this._http = httpSetup;
  }
  get addInspectorRequest() {
    return this._addInspectorRequest;
  }
  set addInspectorRequest(addInspectorRequest) {
    this._addInspectorRequest = addInspectorRequest;
  }
  constructor() {
    (0, _defineProperty2.default)(this, "_http", void 0);
    (0, _defineProperty2.default)(this, "_addInspectorRequest", void 0);
  }
  static getInstance() {
    if (!ApiService.instance) {
      ApiService.instance = new ApiService();
    }
    return ApiService.instance;
  }
  async get(apiUrl, params = {}, decodeType, asResponse = false) {
    var _this$addInspectorReq;
    const {
      version,
      ...queryParams
    } = params;
    const response = await this._http.fetch({
      path: apiUrl,
      query: queryParams,
      asResponse,
      version
    });
    (_this$addInspectorReq = this.addInspectorRequest) === null || _this$addInspectorReq === void 0 ? void 0 : _this$addInspectorReq.call(this, {
      data: response,
      status: _public.FETCH_STATUS.SUCCESS,
      loading: false
    });
    if (decodeType) {
      const decoded = decodeType.decode(response);
      if ((0, _Either.isRight)(decoded)) {
        return decoded.right;
      } else {
        // eslint-disable-next-line no-console
        console.error(`API ${apiUrl} is not returning expected response, ${(0, _securitysolutionIoTsUtils.formatErrors)(decoded.left)} for response`, response);
      }
    }
    return response;
  }
  async post(apiUrl, data, decodeType, params = {}) {
    var _this$addInspectorReq2;
    const {
      version,
      ...queryParams
    } = params;
    const response = await this._http.post(apiUrl, {
      method: 'POST',
      body: JSON.stringify(data),
      query: queryParams,
      version
    });
    (_this$addInspectorReq2 = this.addInspectorRequest) === null || _this$addInspectorReq2 === void 0 ? void 0 : _this$addInspectorReq2.call(this, {
      data: response,
      status: _public.FETCH_STATUS.SUCCESS,
      loading: false
    });
    if (decodeType) {
      const decoded = decodeType.decode(response);
      if ((0, _Either.isRight)(decoded)) {
        return decoded.right;
      } else {
        // eslint-disable-next-line no-console
        console.warn(`API ${apiUrl} is not returning expected response, ${(0, _securitysolutionIoTsUtils.formatErrors)(decoded.left)}`);
      }
    }
    return response;
  }
  async put(apiUrl, data, decodeType, params = {}) {
    const {
      version,
      ...queryParams
    } = params;
    const response = await this._http.put(apiUrl, {
      method: 'PUT',
      body: JSON.stringify(data),
      query: queryParams,
      version
    });
    if (decodeType) {
      const decoded = decodeType.decode(response);
      if ((0, _Either.isRight)(decoded)) {
        return decoded.right;
      } else {
        // eslint-disable-next-line no-console
        console.warn(`API ${apiUrl} is not returning expected response, ${(0, _securitysolutionIoTsUtils.formatErrors)(decoded.left)}`);
      }
    }
    return response;
  }
  async delete(apiUrl, {
    version
  } = {}) {
    const response = await this._http.delete(apiUrl, {
      version
    });
    if (response instanceof Error) {
      throw response;
    }
    return response;
  }
}
(0, _defineProperty2.default)(ApiService, "instance", void 0);
const apiService = exports.apiService = ApiService.getInstance();