"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchMonitorDuration = void 0;
var _utils = require("./utils");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchMonitorDuration = async ({
  monitorId,
  dateStart,
  dateEnd
}) => {
  const queryParams = {
    monitorId,
    dateStart,
    dateEnd
  };
  return await _utils.apiService.get(_constants.API_URLS.MONITOR_DURATION, queryParams);
};
exports.fetchMonitorDuration = fetchMonitorDuration;