"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMLCapabilities = exports.getExistingJobs = exports.fetchAnomalyRecords = exports.deleteMLJob = exports.createMLJob = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _utils = require("./utils");
var _constants = require("../../../../common/constants");
var _ml = require("../../../../common/lib/ml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMLCapabilities = async () => {
  return await _utils.apiService.get(_constants.API_URLS.ML_CAPABILITIES, {
    version: '1'
  });
};
exports.getMLCapabilities = getMLCapabilities;
const getExistingJobs = async () => {
  return await _utils.apiService.get(_constants.API_URLS.ML_MODULE_JOBS + _constants.ML_MODULE_ID, {
    version: '1'
  });
};
exports.getExistingJobs = getExistingJobs;
const createMLJob = async ({
  monitorId,
  heartbeatIndices
}) => {
  var _response$jobs, _response$jobs$;
  const url = _constants.API_URLS.ML_SETUP_MODULE + _constants.ML_MODULE_ID;
  const data = {
    prefix: `${(0, _ml.getJobPrefix)(monitorId)}`,
    useDedicatedIndex: false,
    startDatafeed: true,
    start: (0, _moment.default)().subtract(2, 'w').valueOf(),
    indexPatternName: heartbeatIndices,
    applyToAllSpaces: true,
    query: {
      bool: {
        filter: [{
          term: {
            'monitor.id': monitorId
          }
        }, {
          range: {
            'monitor.duration.us': {
              gt: 0
            }
          }
        }]
      }
    }
  };
  const response = await _utils.apiService.post(url, data, undefined, {
    version: '1'
  });
  if ((response === null || response === void 0 ? void 0 : (_response$jobs = response.jobs) === null || _response$jobs === void 0 ? void 0 : (_response$jobs$ = _response$jobs[0]) === null || _response$jobs$ === void 0 ? void 0 : _response$jobs$.id) === (0, _ml.getMLJobId)(monitorId)) {
    const jobResponse = response.jobs[0];
    const datafeedResponse = response.datafeeds[0];
    if (jobResponse.success) {
      return {
        count: 1,
        jobId: jobResponse.id,
        awaitingNodeAssignment: datafeedResponse.awaitingMlNodeAllocation === true
      };
    } else {
      const {
        error
      } = jobResponse;
      throw new Error((0, _mlErrorUtils.extractErrorMessage)(error));
    }
  } else {
    return null;
  }
};
exports.createMLJob = createMLJob;
const deleteMLJob = async ({
  monitorId
}) => {
  const data = {
    jobIds: [(0, _ml.getMLJobId)(monitorId)]
  };
  return await _utils.apiService.post(_constants.API_URLS.ML_DELETE_JOB, data, undefined, {
    version: '1'
  });
};
exports.deleteMLJob = deleteMLJob;
const fetchAnomalyRecords = async ({
  dateStart,
  dateEnd,
  listOfMonitorIds,
  anomalyThreshold
}) => {
  const data = {
    jobIds: listOfMonitorIds.map(monitorId => (0, _ml.getMLJobId)(monitorId)),
    criteriaFields: [],
    influencers: [],
    aggregationInterval: 'auto',
    threshold: anomalyThreshold !== null && anomalyThreshold !== void 0 ? anomalyThreshold : 25,
    earliestMs: dateStart,
    latestMs: dateEnd,
    dateFormatTz: Intl.DateTimeFormat().resolvedOptions().timeZone,
    maxRecords: 500,
    maxExamples: 10
  };
  return _utils.apiService.post(_constants.API_URLS.ML_ANOMALIES_RESULT, data, undefined, {
    version: '1'
  });
};
exports.fetchAnomalyRecords = fetchAnomalyRecords;