"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLoggingKubernetesHref = exports.getLoggingIpHref = exports.getLoggingContainerHref = void 0;
var _add_base_path = require("./add_base_path");
var _build_href = require("./build_href");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLoggingContainerHref = (summary, basePath) => {
  const getHref = value => {
    if (!value) {
      return undefined;
    }
    const ret = !Array.isArray(value) ? value : value[0];
    return (0, _add_base_path.addBasePath)(basePath, `/app/logs?logFilter=${encodeURI(`(expression:'container.id : ${ret}',kind:kuery)`)}`);
  };
  return (0, _build_href.buildHref)(summary.state.summaryPings || [], ping => {
    var _ping$container;
    return ping === null || ping === void 0 ? void 0 : (_ping$container = ping.container) === null || _ping$container === void 0 ? void 0 : _ping$container.id;
  }, getHref);
};
exports.getLoggingContainerHref = getLoggingContainerHref;
const getLoggingKubernetesHref = (summary, basePath) => {
  const getHref = value => {
    if (!value) {
      return undefined;
    }
    const ret = !Array.isArray(value) ? value : value[0];
    return (0, _add_base_path.addBasePath)(basePath, `/app/logs?logFilter=${encodeURI(`(expression:'pod.uid : ${ret}',kind:kuery)`)}`);
  };
  return (0, _build_href.buildHref)(summary.state.summaryPings || [], ping => {
    var _ping$kubernetes, _ping$kubernetes$pod;
    return ping === null || ping === void 0 ? void 0 : (_ping$kubernetes = ping.kubernetes) === null || _ping$kubernetes === void 0 ? void 0 : (_ping$kubernetes$pod = _ping$kubernetes.pod) === null || _ping$kubernetes$pod === void 0 ? void 0 : _ping$kubernetes$pod.uid;
  }, getHref);
};
exports.getLoggingKubernetesHref = getLoggingKubernetesHref;
const getLoggingIpHref = (summary, basePath) => {
  const getHref = value => {
    if (!value) {
      return undefined;
    }
    const ret = !Array.isArray(value) ? value : value[0];
    return (0, _add_base_path.addBasePath)(basePath, `/app/logs?logFilter=(expression:'${encodeURIComponent(`host.ip : ${ret}`)}',kind:kuery)`);
  };
  return (0, _build_href.buildHref)(summary.state.summaryPings || [], ping => {
    var _ping$monitor;
    return ping === null || ping === void 0 ? void 0 : (_ping$monitor = ping.monitor) === null || _ping$monitor === void 0 ? void 0 : _ping$monitor.ip;
  }, getHref);
};
exports.getLoggingIpHref = getLoggingIpHref;