"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldRedirect = shouldRedirect;
exports.useMappingCheck = useMappingCheck;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function contains(message, phrase) {
  return message.indexOf(phrase) !== -1;
}
function shouldRedirect(error) {
  if (!error || !error.body || error.body.error !== 'Bad Request' || !error.body.message) {
    return false;
  }
  const {
    message
  } = error.body;
  return contains(message, 'search_phase_execution_exception') || contains(message, 'Please use a keyword field instead.') || contains(message, 'set fielddata=true');
}
function useMappingCheck(error) {
  const history = (0, _reactRouterDom.useHistory)();
  (0, _react.useEffect)(() => {
    if (shouldRedirect(error)) {
      history.push(_constants.MAPPING_ERROR_ROUTE);
    }
  }, [error, history]);
}