"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSnapShotCount = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _hooks = require("../../../hooks");
var _selectors = require("../../../state/selectors");
var _contexts = require("../../../contexts");
var _api = require("../../../state/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSnapShotCount = () => {
  const {
    dateRangeStart,
    dateRangeEnd,
    query
  } = (0, _hooks.useGetUrlParams)();
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const esKuery = (0, _reactRedux.useSelector)(_selectors.esKuerySelector);
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => (0, _api.fetchSnapshotCount)({
    query,
    dateRangeStart,
    dateRangeEnd,
    filters: esKuery
  }),
  // FIXME: Dario thinks there is a better way to do this but
  // he's getting tired and maybe the Uptime folks can fix it

  // eslint-disable-next-line react-hooks/exhaustive-deps
  [dateRangeStart, dateRangeEnd, esKuery, lastRefresh, query]);
  return {
    count: data || {
      total: 0,
      up: 0,
      down: 0
    },
    loading
  };
};
exports.useSnapShotCount = useSnapShotCount;