"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorListDrawerComponent = MonitorListDrawerComponent;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _most_recent_error = require("./most_recent_error");
var _monitor_status_list = require("./monitor_status_list");
var _actions_popover_container = require("./actions_popover/actions_popover_container");
var _enabled_alerts = require("./enabled_alerts");
var _monitor_url = require("./monitor_url");
var _most_recent_run = require("./most_recent_run");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContainerDiv = _styledComponents.default.div`
  padding: 10px;
  width: 100%;
`;
/**
 * The elements shown when the user expands the monitor list rows.
 */

function MonitorListDrawerComponent({
  summary,
  monitorDetails,
  loading
}) {
  var _summary$state, _summary$state$url;
  const monitorUrl = (summary === null || summary === void 0 ? void 0 : (_summary$state = summary.state) === null || _summary$state === void 0 ? void 0 : (_summary$state$url = _summary$state.url) === null || _summary$state$url === void 0 ? void 0 : _summary$state$url.full) || '';
  return summary && summary.state.summaryPings ? /*#__PURE__*/_react.default.createElement(ContainerDiv, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      maxWidth: 1000
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_monitor_url.MonitorUrl, {
    monitorUrl: monitorUrl
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_most_recent_run.MostRecentRun, {
    summary: summary
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_actions_popover_container.ActionsPopover, {
    summary: summary
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_monitor_status_list.MonitorStatusList, {
    summaryPings: summary.state.summaryPings
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_enabled_alerts.EnabledAlerts, {
    loading: loading,
    monitorAlerts: monitorDetails === null || monitorDetails === void 0 ? void 0 : monitorDetails.alerts
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), monitorDetails && monitorDetails.error && /*#__PURE__*/_react.default.createElement(_most_recent_error.MostRecentError, {
    error: monitorDetails.error,
    monitorId: summary.monitor_id,
    timestamp: monitorDetails.timestamp
  })) : null;
}