"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationDeprecationCallout = IntegrationDeprecationCallout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_services = require("../../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IntegrationDeprecationCallout({
  handleDismissDeprecationNotice
}) {
  var _getDocLinks, _getDocLinks$links, _getDocLinks$links$ob;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.integration.deprecation.title",
      defaultMessage: "Migrate your Elastic Synthetics integration monitors"
    }),
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.integration.deprecation.content",
    defaultMessage: "You have at least one monitor configured using the Elastic Synthetics integration. From Elastic 8.8, the integration is deprecated and you can no longer edit these monitors. Please migrate them to Project monitors or add them to the new Synthetics app directly available in Observability. Check our {link} for more details.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsIntegrationDeprecationCalloutSyntheticsMigrationDocsLink",
        target: "_blank",
        href: (_getDocLinks = (0, _kibana_services.getDocLinks)()) === null || _getDocLinks === void 0 ? void 0 : (_getDocLinks$links = _getDocLinks.links) === null || _getDocLinks$links === void 0 ? void 0 : (_getDocLinks$links$ob = _getDocLinks$links.observability) === null || _getDocLinks$links$ob === void 0 ? void 0 : _getDocLinks$links$ob.syntheticsMigrateFromIntegration,
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.uptime.integration.deprecation.link",
        defaultMessage: "Synthetics migration docs"
      }))
    }
  }))), handleDismissDeprecationNotice ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsIntegrationDeprecationCalloutDismissButton",
    onClick: handleDismissDeprecationNotice,
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.integration.deprecation.dismiss",
    defaultMessage: "Dismiss"
  }))) : null));
}