"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeUnitSelectable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeUnitSelectable = ({
  'aria-label': ariaLabel,
  'data-test-subj': dataTestSubj,
  headlineText: headlineText,
  onChange,
  timeRangeOptions
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, headlineText)), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": ariaLabel,
    "data-test-subj": dataTestSubj,
    options: timeRangeOptions,
    onChange: onChange,
    singleSelection: true,
    listProps: {
      showIcons: true
    }
  }, list => list));
};
exports.TimeUnitSelectable = TimeUnitSelectable;