"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepPageNavigation = exports.PREVIOUS_CHECK_BUTTON_TEXT = exports.NEXT_CHECK_BUTTON_TEXT = exports.CURRENT_CHECK_ARIA_LABEL = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PREVIOUS_CHECK_BUTTON_TEXT = exports.PREVIOUS_CHECK_BUTTON_TEXT = _i18n.i18n.translate('xpack.uptime.synthetics.stepDetail.previousCheckButtonText', {
  defaultMessage: 'Previous check'
});
const NEXT_CHECK_BUTTON_TEXT = exports.NEXT_CHECK_BUTTON_TEXT = _i18n.i18n.translate('xpack.uptime.synthetics.stepDetail.nextCheckButtonText', {
  defaultMessage: 'Next check'
});
const CURRENT_CHECK_ARIA_LABEL = timestamp => _i18n.i18n.translate('xpack.uptime.synthetics.stepDetail.currentCheckAriaLabel', {
  defaultMessage: 'Current check: {timestamp}',
  values: {
    timestamp
  }
});
exports.CURRENT_CHECK_ARIA_LABEL = CURRENT_CHECK_ARIA_LABEL;
const StepPageNavigation = ({
  previousCheckGroup,
  dateFormat,
  handleNextRun,
  handlePreviousRun,
  checkTimestamp,
  nextCheckGroup
}) => {
  const formattedTimestamp = (0, _moment.default)(checkTimestamp).format(dateFormat);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepPageNavigationButton",
    onClick: handlePreviousRun,
    disabled: !previousCheckGroup,
    iconType: "arrowLeft",
    "aria-label": PREVIOUS_CHECK_BUTTON_TEXT
  }, PREVIOUS_CHECK_BUTTON_TEXT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "aria-label": CURRENT_CHECK_ARIA_LABEL(formattedTimestamp)
  }, formattedTimestamp)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepPageNavigationButton",
    onClick: handleNextRun,
    disabled: !nextCheckGroup,
    iconType: "arrowRight",
    iconSide: "right",
    "aria-label": NEXT_CHECK_BUTTON_TEXT
  }, NEXT_CHECK_BUTTON_TEXT)));
};
exports.StepPageNavigation = StepPageNavigation;